#include "GetPoint.js"

function DoHelix()
{
	var ui = moi.ui;
	
	var pointpicker = ui.createPointPicker();
	
	// Start by getting the axis base point.
	if ( !GetPoint( pointpicker ) )
		return;
		
	var factory = moi.command.createFactory( 'helix' );
	var basept = pointpicker.ptFrame;
	factory.setInput( 0, basept );


	// Now get the end point of the axis.
		
	ui.beginUIUpdate();
	ui.hideUI( 'AxisStartPrompt' );
	ui.showUI( 'AxisEndPrompt' );
	ui.showUI( 'FlatSpiralContainer' );
	ui.endUIUpdate();
	
	pointpicker.bindResultPt( factory.getInput(1) );
	
	var endpt, flatspiral = false;
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
		{
			endpt = pointpicker.pt;
			break;
		}
			
		if ( pointpicker.event == 'FlatSpiral' )
		{
			// For flat spiral mode, set the endpoint to the same as the starting point.
			
			endpt = basept.origin;
			flatspiral = true;
			break;
		}
	}
	
	factory.setInput( 1, endpt );

	// Now get the first radius.
		
	ui.beginUIUpdate();

	ui.hideUI( 'AxisEndPrompt' );
	ui.hideUI( 'FlatSpiralContainer' );
	ui.showUI( 'StartRadiusPrompt' );
	ui.showUI( 'StartRadiusOptions' );
	if ( flatspiral )
		ui.hideUI( 'Tapered' );
	
	ui.endUIUpdate();
	
	
	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(2) );
	ui.commandUI.g_Factory = factory;
	pointpicker.bindFuncPostUpdate( ui.commandUI.StartRadiusFunc );
	pointpicker.setBasePt( basept.origin );
	
	var startplane = factory.getStartPlane();
	if ( startplane == null )
		return;
	
	pointpicker.restrictToPlane( startplane, true );
	pointpicker.disableVerticalStraightSnap = true;
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
			break;
			
		if ( pointpicker.event == 'StartRadius' )
		{
			// An explicit radius was entered. We still need a point, but we will set the
			// distance constraint on it.
			var radius = ui.commandUI.StartRadius.value;
			if ( radius > 0.0 )
			{
				ui.commandUI.g_HaveStartRadius = true;
				pointpicker.setDistanceConstraint( radius );
				factory.setInput( 3, radius );
			}
		}
	}
	
	// If 'Tapered' was checked, or if we are doing a flat spiral, then get the ending radius.
		
	if ( ui.commandUI.Tapered.value || flatspiral )
	{
		ui.beginUIUpdate();
		ui.hideUI( 'Tapered' );
		ui.hideUI( 'StartRadiusPrompt' );
		ui.hideUI( 'StartRadiusOptions' );
		ui.showUI( 'EndRadiusPrompt' );
		ui.showUI( 'EndRadiusOptions' );
		ui.endUIUpdate();
		
		pointpicker.reset();
		pointpicker.bindResultPt( factory.getInput(4) );
		pointpicker.bindFuncPostUpdate( ui.commandUI.EndRadiusFunc );
		pointpicker.setBasePt( endpt );

		var endplane = factory.getEndPlane();
		if ( endplane == null )
			return;
		
		pointpicker.restrictToPlane( endplane, true );
		pointpicker.disableVerticalStraightSnap = true;
		
		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
				return;
				
			if ( pointpicker.event == 'finished' )
			{
				ui.removeLastPickedPoint();
				break;
			}
				
			if ( pointpicker.event == 'EndRadius' )
			{
				// An explicit end radius was entered.
				var radius = ui.commandUI.EndRadius.value;
				if ( radius > 0.0 )
				{
					factory.setInput( 5, radius );
					break;
				}
			}
		}
	}

	// Now we want to let options for number of turns, pitch, and reverse twist be set.

	
	// Get the last used mode, default to number of turns.

	var mode = 'turns';

	try { mode = moi.command.getOption( 'HelixMode' ); }
	catch(e) { }
	
	// If we're doing a flat spiral, always set to turns mode, pitch is hidden in this case.
	if ( factory.getHeight() == 0.0 )
		mode = 'turns';

	factory.setInput( 8, mode );
	
	var TurnsStyle = ui.commandUI.TurnsLabel.style;
	var PitchStyle = ui.commandUI.PitchLabel.style;
	
	if ( mode == 'turns' )
	{
		// Initialize with turns mode, get the last number of turns.
	
		var NumTurns = 5;
		
		try	{ NumTurns = moi.command.getOption( 'HelixTurns' ); }
		catch(e) { }
		
		factory.setInput( 6, NumTurns );
		ui.commandUI.Turns.value = NumTurns;
		
		var height = factory.getHeight();
		if ( height > 0.0 )
			ui.commandUI.Pitch.value = height / NumTurns;
			
		TurnsStyle.textDecoration = 'underline';
	}
	else
	{
		// Initialize with pitch mode.
		
		var Pitch = 1.0;
		
		try { Pitch = moi.command.getOption( 'HelixPitch' ); }
		catch(e) {}
		
		factory.setInput( 7, Pitch );
		ui.commandUI.Pitch.value = Pitch;
		
		var height = factory.getHeight();
		if ( height > 0.0 )
			ui.commandUI.Turns.value = height / Pitch;
		
		PitchStyle.textDecoration = 'underline';
	}

	ui.bindUIToInput( 'ReverseTwist', 'value', factory.getInput(9) );
	
	ui.beginUIUpdate();
	ui.hideUI( 'Tapered' );
	ui.hideUI( 'StartRadiusPrompt' );
	ui.hideUI( 'StartRadiusOptions' );
	ui.hideUI( 'EndRadiusPrompt' );
	ui.hideUI( 'EndRadiusOptions' );
	ui.showUI( 'OptionsPrompt' );
	ui.showUI( 'HelixOptions' );
	ui.showUI( 'done' );
	
	if ( factory.getHeight() == 0.0 )
		ui.hideUI( 'PitchTR' );
	
	ui.endUIUpdate();
	
	var dialog = ui.commandDialog;
	
	while ( 1 )
	{
		if ( !dialog.waitForEvent() )
			return;
			
		if ( dialog.event == 'done' )
			break;
			
		if ( dialog.event == 'Turns' )
		{
			// Switch the mode to turns mode.
			factory.setInput( 8, 'turns' );

			var NumTurns = ui.commandUI.Turns.value;
			factory.setInput( 6, NumTurns );
			
			// Remember this as the last used turns value.
			moi.command.setOption( 'HelixTurns', NumTurns );
			moi.command.setOption( 'HelixMode', 'turns' );
			
			factory.update();
			
			// Update the pitch.
			var height = factory.getHeight();
			if ( height > 0.0 )
				ui.commandUI.Pitch.value = height / NumTurns;
			
			PitchStyle.textDecoration = 'none';
			TurnsStyle.textDecoration = 'underline';
		}
		else if ( dialog.event == 'Pitch' )
		{
			// Switch the mode to pitch mode.
			factory.setInput( 8, 'pitch' );
			
			var Pitch = ui.commandUI.Pitch.value;
			factory.setInput( 7, Pitch );

			// Remember this as the last used pitch value.
			moi.command.setOption( 'HelixPitch', Pitch );
			moi.command.setOption( 'HelixMode', 'pitch' );
			
			factory.update();
			
			// Update the turns.
			var height = factory.getHeight();
			if ( height > 0.0 )
				ui.commandUI.Turns.value = height / Pitch;
			
			TurnsStyle.textDecoration = 'none';
			PitchStyle.textDecoration = 'underline';
		}
	}	

	factory.commit();
}

DoHelix();
